/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.nhm.eui.GIFEncoder;
import ibm.nways.nhm.eui.GifFilenameFilter;
import ibm.nways.nhm.eui.NhmDataRetriever;
import ibm.nways.nhm.eui.NhmReportDialog;
import ibm.nways.nhm.eui.NhmReportNodeDialog;
import ibm.nways.nhm.eui.NhmView;
import ibm.nways.nhm.eui.NhmViewNotebook;
import ibm.nways.nhm.eui.ReportEditorFrame;
import ibm.nways.nhm.eui.SimpleListDialog;
import ibm.nways.nhm.file_server.FileInfo;
import ibm.nways.nhm.file_server.RemoteDirectory;
import ibm.nways.nhm.file_server.RemoteInputStream;
import ibm.nways.nhm.file_server.RemoteOutputStream;
import ibm.nways.ras.Traces;
import java.applet.Applet;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import jclass.chart.JCChart;

public class NhmReportEditor {
    private Frame parent;
    private String server;
    private Applet appl;
    private int serverPort;
    private int standardHeaderLength = -1;
    private DateFormat df = DateFormat.getDateTimeInstance(1, 1);
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");

    public NhmReportEditor(Frame frame, String string, Applet applet, int n) {
        this.df.setTimeZone(TimeZone.getDefault());
        this.parent = frame;
        this.server = string;
        this.appl = applet;
        this.serverPort = n;
    }

    public void addCurrentView(NhmViewNotebook nhmViewNotebook) {
        NhmView nhmView = null;
        NhmReportDialog nhmReportDialog = null;
        try {
            nhmView = (NhmView)nhmViewNotebook.getCurrentPage();
        }
        catch (ClassCastException classCastException) {}
        if (nhmView != null) {
            nhmReportDialog = new NhmReportDialog(this.parent, 3, this.appl, this.server, this.serverPort);
            nhmReportDialog.show();
        }
        if (nhmView != null && nhmReportDialog.getResult() != 1) {
            String[] stringArray = new String[]{nhmViewNotebook.getResourceManager().dpGetHostname()};
            DpResourceInstance dpResourceInstance = nhmViewNotebook.getResourceManager().dpGetResourceInstance();
            nhmView.getTitle();
            String string = nhmViewNotebook.getResourceManager().dpGetResourceType();
            String string2 = nhmReportDialog.getAppletType();
            if (this.nhmRes.getString("s_chart").equals(string2)) {
                if (nhmReportDialog.getSaveAsImage()) {
                    this.addCurrentImage(nhmReportDialog, nhmViewNotebook);
                    return;
                }
                this.addChartApplet(nhmReportDialog, nhmView, stringArray, dpResourceInstance);
                return;
            }
            if (this.nhmRes.getString("s_statAn").equals(string2)) {
                this.addAnalysisApplet(nhmReportDialog, string, stringArray[0], dpResourceInstance);
                return;
            }
            if (this.nhmRes.getString("s_multNode").equals(string2)) {
                this.addMultipleNodeApplet(nhmReportDialog, nhmView, stringArray, dpResourceInstance, string);
            }
        }
    }

    public void addCurrentImage(NhmViewNotebook nhmViewNotebook) {
        NhmReportDialog nhmReportDialog = new NhmReportDialog(this.parent, 6, this.appl, this.server, this.serverPort);
        nhmReportDialog.show();
        if (nhmReportDialog.getResult() != 1) {
            this.addCurrentImage(nhmReportDialog, nhmViewNotebook);
        }
    }

    protected void addCurrentImage(NhmReportDialog nhmReportDialog, NhmViewNotebook nhmViewNotebook) {
        NhmView nhmView = (NhmView)nhmViewNotebook.getCurrentPage();
        if (nhmView != null) {
            try {
                JCChart jCChart = (JCChart)nhmView.getCurrentComponent();
                String string = this.saveChartToGifFile(jCChart, nhmView.getTitle().replace(' ', '_'));
                String string2 = "reports" + File.separator + nhmReportDialog.getReportName() + ".html";
                StringBuffer stringBuffer = this.readReport(string2);
                String string3 = stringBuffer.toString();
                PrintWriter printWriter = new PrintWriter((OutputStream)new RemoteOutputStream(string2, this.server, this.serverPort, false));
                int n = this.printUpToLastApplet(string3, printWriter);
                printWriter.println();
                printWriter.println("<! -- Image tag added by Performance Manager>");
                printWriter.println("<center>");
                printWriter.print("<img src=\"");
                printWriter.print(string);
                printWriter.println("\" BORDER=0 ALIGN=bottom>");
                printWriter.println("</center>");
                printWriter.println("<! -- end of image added by Performance Manager>");
                printWriter.write(string3, n, string3.length() - n);
                printWriter.close();
                return;
            }
            catch (Exception exception) {
                Traces.logException(exception);
                exception.printStackTrace();
                return;
            }
        }
    }

    public void launchReport() {
        try {
            NhmReportDialog nhmReportDialog = new NhmReportDialog(this.parent, 2, this.appl, this.server, this.serverPort);
            nhmReportDialog.setReportName("");
            nhmReportDialog.show();
            if (nhmReportDialog.getResult() == 2 && nhmReportDialog.getReportName().length() > 0) {
                String string = this.appl.getDocumentBase().toString();
                int n = 47;
                string = string.substring(0, string.lastIndexOf(n));
                string = string.concat("/reports/");
                string = string.concat(nhmReportDialog.getReportName());
                string = string.concat(".html");
                this.launchDocument(string, nhmReportDialog.getReportName());
            }
            nhmReportDialog = null;
            return;
        }
        catch (Exception exception) {
            Traces.logException(exception);
            exception.printStackTrace();
            return;
        }
    }

    public void showReportCatalog() {
        try {
            String string = this.appl.getDocumentBase().toString();
            int n = 47;
            string = string.substring(0, string.lastIndexOf(n));
            string = string.concat("/reports/ReportCatalog.html");
            this.launchDocument(string, this.nhmRes.getString("s_reportCat"));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void modifyReportOptions() {
        this.editReport();
    }

    public void editReport() {
        NhmReportDialog nhmReportDialog = new NhmReportDialog(this.parent, 5, this.appl, this.server, this.serverPort);
        nhmReportDialog.show();
        if (nhmReportDialog.getResult() != 1) {
            ReportEditorFrame reportEditorFrame = new ReportEditorFrame(nhmReportDialog.getReportName(), this.appl, this.serverPort);
            reportEditorFrame.show();
            reportEditorFrame.loadFile();
        }
    }

    private boolean launchDocument(String string, String string2) {
        boolean bl = true;
        try {
            if (this.appl instanceof BrowserApplet) {
                BrowserApplet browserApplet = (BrowserApplet)this.appl;
                browserApplet.launchWebBrowser(string);
            } else {
                URL uRL = new URL(string);
                this.appl.getAppletContext().showDocument(uRL, string2);
            }
        }
        catch (Exception exception) {
            Traces.logError(this, "exception caught trying to launch report " + string);
            Traces.logException(exception);
            bl = false;
        }
        return bl;
    }

    private void addChartApplet(NhmReportDialog nhmReportDialog, NhmView nhmView, String[] object, DpResourceInstance dpResourceInstance) {
        Object object2;
        String string = nhmView.getTitle();
        Vector<DpResourceInstance> vector = new Vector<DpResourceInstance>();
        vector.addElement(dpResourceInstance);
        String string2 = String.valueOf(this.nhmRes.getString("s_AddHosts")) + string;
        if (nhmReportDialog.promptForMoreHostnames()) {
            object2 = new NhmReportNodeDialog(this.parent, string2, vector, (String[])object, this.appl);
            ((Dialog)object2).show();
            object = ((NhmReportNodeDialog)object2).getResult() != 1 ? ((NhmReportNodeDialog)object2).getHosts() : null;
        }
        if (object != null) {
            try {
                object2 = this.createDateTags(nhmReportDialog);
                String string3 = "reports" + File.separator + nhmReportDialog.getReportName() + ".html";
                StringBuffer stringBuffer = this.readReport(string3);
                String string4 = stringBuffer.toString();
                PrintWriter printWriter = new PrintWriter((OutputStream)new RemoteOutputStream(string3, this.server, this.serverPort, false));
                int n = this.printUpToLastApplet(string4, printWriter);
                this.addChartTags(printWriter, (String[])object, string, (DpResourceInstance)vector.elementAt(0), false, (String[])object2);
                printWriter.write(string4, n, string4.length() - n);
                printWriter.close();
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
            catch (NotBoundException notBoundException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private void addAnalysisApplet(NhmReportDialog nhmReportDialog, String string, String string2, DpResourceInstance dpResourceInstance) {
        String[] stringArray = new String[]{string2};
        Vector<DpResourceInstance> vector = new Vector<DpResourceInstance>();
        vector.addElement(dpResourceInstance);
        String string3 = String.valueOf(this.nhmRes.getString("s_AddHostsRes")) + string;
        if (nhmReportDialog.promptForMoreHostnames()) {
            NhmReportNodeDialog nhmReportNodeDialog = new NhmReportNodeDialog(this.parent, string3, vector, stringArray, this.appl);
            nhmReportNodeDialog.show();
            if (nhmReportNodeDialog.getResult() != 1) {
                stringArray = nhmReportNodeDialog.getHosts();
            }
        }
        try {
            String string4 = "reports" + File.separator + nhmReportDialog.getReportName() + ".html";
            StringBuffer stringBuffer = this.readReport(string4);
            String string5 = stringBuffer.toString();
            String[] stringArray2 = this.createDateTags(nhmReportDialog);
            PrintWriter printWriter = new PrintWriter((OutputStream)new RemoteOutputStream(string4, this.server, this.serverPort, false));
            int n = this.printUpToLastApplet(string5, printWriter);
            String[] stringArray3 = new String[1];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray3[0] = stringArray[n2];
                this.addChartTags(printWriter, stringArray3, string, (DpResourceInstance)vector.elementAt(n2), true, stringArray2);
                ++n2;
            }
            printWriter.write(string5, n, string5.length() - n);
            printWriter.close();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        catch (NotBoundException notBoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void addMultipleNodeApplet(NhmReportDialog nhmReportDialog, NhmView nhmView, String[] stringArray, DpResourceInstance dpResourceInstance, String string) {
        Object object;
        String string2 = null;
        NhmDataRetriever nhmDataRetriever = new NhmDataRetriever(this.server, this.serverPort);
        Vector vector = nhmDataRetriever.getPollingDefinitions(string);
        boolean bl = false;
        if (vector != null) {
            object = new SimpleListDialog(this.parent, this.nhmRes.getString("s_SelectPollDef"), vector);
            ((Dialog)object).show();
            bl = ((SimpleListDialog)object).getResult() == 2;
            string2 = ((SimpleListDialog)object).getSelection();
        } else {
            bl = true;
            Traces.logError(this, "failed to retrieve polling definitions for " + string);
        }
        if (!bl) {
            Object object2;
            object = "reports" + File.separator + nhmReportDialog.getReportName() + ".html";
            StringBuffer stringBuffer = null;
            Vector<Object> vector2 = new Vector<Object>();
            stringBuffer = this.readReport((String)object);
            if (nhmReportDialog.addToExistingApplet()) {
                object2 = new BufferedReader(new StringReader(stringBuffer.toString()));
                this.findExistingNodes((BufferedReader)object2, stringArray, vector2, string2);
            } else {
                int n = 1;
                while (n < stringArray.length) {
                    vector2.addElement(dpResourceInstance.clone());
                    ++n;
                }
            }
            object2 = new NhmReportNodeDialog(this.parent, this.nhmRes.getString("s_SpecifyHost"), vector2, stringArray, this.appl);
            ((Dialog)object2).show();
            if (((NhmReportNodeDialog)object2).getResult() != 1) {
                String[] stringArray2 = this.createDateTags(nhmReportDialog);
                stringArray = ((NhmReportNodeDialog)object2).getHosts();
                if (nhmReportDialog.addToExistingApplet()) {
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(stringBuffer.toString()));
                    this.updateMultipleNodeTags(bufferedReader, (String)object, string2, stringArray, vector2);
                    return;
                }
                try {
                    String string3 = stringBuffer.toString();
                    PrintWriter printWriter = new PrintWriter((OutputStream)new RemoteOutputStream((String)object, this.server, this.serverPort, false));
                    int n = this.printUpToLastApplet(string3, printWriter);
                    this.addMultipleNodeTags(printWriter, string2, stringArray, vector2, stringArray2);
                    printWriter.write(string3, n, string3.length() - n);
                    printWriter.close();
                    return;
                }
                catch (Exception exception) {
                    Traces.logException(exception);
                    exception.printStackTrace();
                    return;
                }
            }
        }
    }

    private DpResourceInstance createInstancesFromString(String string) {
        int n;
        String string2;
        DpResourceInstance dpResourceInstance = new DpResourceInstance();
        int n2 = 0;
        int n3 = string.indexOf(",");
        while (n3 != -1) {
            string2 = string.substring(n2 + 1, n3);
            n = string2.indexOf("=");
            dpResourceInstance.dpAddInstanceDescriptor(string2.substring(0, n), string2.substring(n + 1, string2.length()));
            n2 = n3;
            n3 = string.indexOf(",", n2 + 1);
        }
        string2 = string.substring(n2 + 1);
        n = string2.indexOf("=");
        dpResourceInstance.dpAddInstanceDescriptor(string2.substring(0, n), string2.substring(n + 1, string2.length()));
        return dpResourceInstance;
    }

    private StringBuffer readReport(String string) {
        StringBuffer stringBuffer;
        block16: {
            stringBuffer = new StringBuffer(500);
            try {
                DataInputStream dataInputStream = new DataInputStream((InputStream)new RemoteInputStream(string, this.server, this.serverPort));
                try {
                    int n;
                    while ((n = dataInputStream.read()) != -1) {
                        stringBuffer.append((char)n);
                    }
                }
                catch (EOFException eOFException) {}
                dataInputStream.close();
                this.standardHeaderLength = -1;
            }
            catch (RemoteException remoteException) {
                if (!(remoteException.detail instanceof RemoteException) || !remoteException.detail.getMessage().startsWith("File does not exist")) break block16;
                String string2 = "reports" + File.separator + "standard_header.html";
                try {
                    int n = 0;
                    while (n < 2) {
                        DataInputStream dataInputStream = new DataInputStream((InputStream)new RemoteInputStream(string2, this.server, this.serverPort));
                        try {
                            int n2;
                            while ((n2 = dataInputStream.read()) != -1) {
                                stringBuffer.append((char)n2);
                            }
                        }
                        catch (EOFException eOFException) {}
                        dataInputStream.close();
                        if (n == 0) {
                            string2 = "reports" + File.separator + "standard_trailer.html";
                            stringBuffer.append("\n");
                            this.standardHeaderLength = stringBuffer.length();
                        }
                        ++n;
                    }
                    this.updateReportCatalog(string.substring(8));
                }
                catch (RemoteException remoteException2) {
                }
                catch (NotBoundException notBoundException) {
                }
                catch (IOException iOException) {}
            }
            catch (NotBoundException notBoundException) {
            }
            catch (IOException iOException) {}
        }
        return stringBuffer;
    }

    private int printUpToLastApplet(String string, PrintWriter printWriter) {
        int n = string.lastIndexOf("<! -- end");
        if (n < 0) {
            n = string.lastIndexOf("</APPLET>");
            if (n < 0) {
                n = string.lastIndexOf("</applet>");
            }
            if (n < 0) {
                if (this.standardHeaderLength > 0) {
                    n = this.standardHeaderLength;
                } else {
                    n = string.lastIndexOf("</body>");
                    if (n < 0) {
                        n = string.lastIndexOf("</BODY>");
                    }
                    if (n < 0) {
                        n = string.lastIndexOf("</html>");
                    }
                    if (n < 0) {
                        n = string.lastIndexOf("</HTML>");
                    }
                    if (n < 0) {
                        n = string.length();
                    }
                }
            } else {
                n += 10;
            }
        } else {
            n = string.indexOf(62, n) + 1;
        }
        printWriter.write(string, 0, n);
        return n;
    }

    private void addChartTags(PrintWriter printWriter, String[] stringArray, String string, DpResourceInstance dpResourceInstance, boolean bl, String[] stringArray2) {
        printWriter.println();
        printWriter.println("<! -- beginning of Applet tag added by Performance Manager> ");
        if (bl) {
            printWriter.print("<APPLET code=ibm.nways.nhm.eui.SingleNodeAnalysisApplet width=100% height=75%");
        } else {
            printWriter.print("<APPLET code=ibm.nways.nhm.eui.NhmChartApplet width=100% height=75%");
        }
        NhmDataRetriever nhmDataRetriever = new NhmDataRetriever(this.server, this.serverPort);
        String string2 = nhmDataRetriever.getReportSetting("codebase");
        if (string2 != null && string2.length() > 0) {
            printWriter.print(" codebase=\"");
            printWriter.print(string2);
            printWriter.print("\"");
        }
        printWriter.print(" ARCHIVE=\"ClientClasses.jar\"");
        printWriter.println(">");
        printWriter.print("<param NAME=port_num VALUE=");
        printWriter.print(this.serverPort);
        printWriter.println(">");
        int n = 0;
        while (n < stringArray2.length) {
            printWriter.println(stringArray2[n]);
            ++n;
        }
        if (bl) {
            printWriter.print("<param NAME=host_name VALUE=\"");
            printWriter.print(stringArray[0]);
            printWriter.println("\">");
            printWriter.print("<param NAME=resource_name VALUE=\"");
        } else {
            printWriter.print("<param NAME=number_of_nodes VALUE=");
            printWriter.print(stringArray.length);
            printWriter.println(">");
            n = 0;
            while (n < stringArray.length) {
                printWriter.print("<param NAME=host_name_");
                printWriter.print(n + 1);
                printWriter.print(" VALUE=\"");
                printWriter.print(stringArray[n]);
                printWriter.println("\">");
                ++n;
            }
            printWriter.print("<param NAME=view_name VALUE=\"");
        }
        printWriter.print(string);
        printWriter.println("\">");
        printWriter.print("<param NAME=instance VALUE=\"");
        if (dpResourceInstance != null) {
            Enumeration enumeration = dpResourceInstance.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = dpResourceInstance.dpGetInstanceDescriptor(string3);
                printWriter.print(string3);
                printWriter.print("=");
                printWriter.print(string4);
                if (!enumeration.hasMoreElements()) continue;
                printWriter.print(",");
            }
        }
        printWriter.println("\">");
        printWriter.println("</APPLET>");
        printWriter.println("<! -- end of Applet tag added by Performance Manager> ");
        printWriter.println();
    }

    private void addMultipleNodeTags(PrintWriter printWriter, String string, String[] stringArray, Vector vector, String[] stringArray2) {
        try {
            printWriter.println();
            printWriter.println("<! -- beginning of Applet tag added by Performance Manager> ");
            printWriter.print("<APPLET code=ibm.nways.nhm.eui.MultipleNodeAnalysisApplet width=100% height=75%");
            NhmDataRetriever nhmDataRetriever = new NhmDataRetriever(this.server, this.serverPort);
            String string2 = nhmDataRetriever.getReportSetting("codebase");
            if (string2 != null && string2.length() > 0) {
                printWriter.print(" codebase=\"");
                printWriter.print(string2);
                printWriter.print("\"");
            }
            printWriter.print(" ARCHIVE=\"ClientClasses.jar\"");
            printWriter.println(">");
            printWriter.print("<param NAME=port_num VALUE=");
            printWriter.print(this.serverPort);
            printWriter.println(">");
            printWriter.print("<param NAME=polling_object_id VALUE=\"");
            printWriter.print(string);
            printWriter.println("\">");
            int n = 0;
            while (n < stringArray2.length) {
                printWriter.println(stringArray2[n]);
                ++n;
            }
            printWriter.print("<param NAME=number_of_nodes VALUE=");
            printWriter.print(stringArray.length);
            printWriter.println(">");
            n = 0;
            while (n < stringArray.length) {
                printWriter.print("<param NAME=host_name_");
                printWriter.print(n + 1);
                printWriter.print(" VALUE=");
                printWriter.print(stringArray[n]);
                printWriter.println(">");
                if (n < vector.size()) {
                    printWriter.print("<param NAME=instance_");
                    printWriter.print(n + 1);
                    printWriter.print(" VALUE=\"");
                    DpResourceInstance dpResourceInstance = (DpResourceInstance)vector.elementAt(n);
                    Enumeration enumeration = dpResourceInstance.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        String string4 = dpResourceInstance.dpGetInstanceDescriptor(string3);
                        printWriter.print(string3);
                        printWriter.print("=");
                        printWriter.print(string4);
                        if (!enumeration.hasMoreElements()) continue;
                        printWriter.print(",");
                    }
                    printWriter.println("\">");
                } else {
                    printWriter.print("<param NAME=instance_");
                    printWriter.print(n + 1);
                    printWriter.println(" VALUE=\"\">");
                }
                ++n;
            }
            printWriter.println("</APPLET>");
            printWriter.println("<! -- end of Applet tag added by Performance Manager> ");
            printWriter.println();
            return;
        }
        catch (Exception exception) {
            Traces.logException(exception);
            return;
        }
    }

    private void updateMultipleNodeTags(BufferedReader bufferedReader, String string, String string2, String[] stringArray, Vector vector) {
        try {
            PrintWriter printWriter = new PrintWriter((OutputStream)new RemoteOutputStream(string, this.server, this.serverPort, true));
            String string3 = bufferedReader.readLine();
            while (string3 != null && string3.indexOf(string2) == -1) {
                string3 = bufferedReader.readLine();
                printWriter.println(string3);
            }
            if (string3 != null) {
                printWriter.println(string3);
                printWriter.println(bufferedReader.readLine());
                printWriter.println(bufferedReader.readLine());
                int n = 0;
                while (n < stringArray.length) {
                    printWriter.print("<param NAME=host_name_");
                    printWriter.print(n + 1);
                    printWriter.print("VALUE=");
                    printWriter.print(stringArray[n]);
                    printWriter.println(">");
                    printWriter.print("<param NAME=instance_");
                    printWriter.print(n + 1);
                    printWriter.print("VALUE=\"");
                    DpResourceInstance dpResourceInstance = (DpResourceInstance)vector.elementAt(n);
                    Enumeration enumeration = dpResourceInstance.keys();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        String string5 = dpResourceInstance.dpGetInstanceDescriptor(string4);
                        printWriter.print(string4);
                        printWriter.print("=");
                        printWriter.print(string5);
                        if (!enumeration.hasMoreElements()) continue;
                        printWriter.print(",");
                    }
                    printWriter.println("\">");
                    ++n;
                }
            }
            while (string3 != null && string3.indexOf("</APPLET>") == -1) {
                string3 = bufferedReader.readLine();
            }
            while (string3 != null) {
                printWriter.println(string3);
                string3 = bufferedReader.readLine();
            }
            printWriter.close();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        catch (NotBoundException notBoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void findExistingNodes(BufferedReader bufferedReader, String[] stringArray, Vector vector, String string) {
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null && string2.indexOf(string) == -1) {
                string2 = bufferedReader.readLine();
            }
            if (string2 != null) {
                bufferedReader.readLine();
                bufferedReader.readLine();
                int n = Integer.parseInt(bufferedReader.readLine());
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    string2 = bufferedReader.readLine();
                    int n3 = string2.indexOf("VALUE=");
                    stringArray[n2] = string2.substring(n3 + 7, string2.length() - 2);
                    string2 = bufferedReader.readLine();
                    n3 = string2.indexOf("VALUE=");
                    vector.addElement(this.createInstancesFromString(string2.substring(n3 + 7, string2.length() - 2)));
                    ++n2;
                }
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        catch (Exception exception) {}
    }

    private void updateReportCatalog(String string) {
        String string2 = !File.separator.equals("/") ? string.replace(File.separatorChar, '/') : string;
        try {
            StringBuffer stringBuffer = new StringBuffer(500);
            String string3 = "reports" + File.separator + "ReportCatalog.html";
            DataInputStream dataInputStream = new DataInputStream((InputStream)new RemoteInputStream(string3, this.server, this.serverPort));
            try {
                int n;
                while ((n = dataInputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
            }
            catch (EOFException eOFException) {}
            dataInputStream.close();
            String string4 = stringBuffer.toString();
            if (string4.indexOf(string2) == -1) {
                int n = string4.lastIndexOf("</body>");
                if (n == -1) {
                    n = string4.length() - 7;
                }
                PrintWriter printWriter = new PrintWriter((OutputStream)new RemoteOutputStream(string3, this.server, this.serverPort));
                printWriter.print(string4.substring(0, n - 1));
                printWriter.println();
                printWriter.print("<p><a href=\"");
                printWriter.print(string2);
                printWriter.print("\">");
                printWriter.print(string2.substring(0, string2.length() - 5));
                printWriter.println("</a>");
                printWriter.print(string4.substring(n, string4.length()));
                printWriter.close();
                return;
            }
        }
        catch (Exception exception) {
            Traces.logError(this, "Exception handled in updateReportCatalog: ");
            Traces.logException(exception);
        }
    }

    private String[] createDateTags(NhmReportDialog nhmReportDialog) {
        String[] stringArray = new String[2];
        if (nhmReportDialog.getTimeRange() == 0) {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("<param NAME=start_date VALUE=\"");
            stringBuffer.append(this.df.format(nhmReportDialog.getStartDate()));
            stringBuffer.append("\">");
            stringArray[0] = stringBuffer.toString();
            stringBuffer = new StringBuffer(50);
            stringBuffer.append("<param NAME=end_date VALUE=\"");
            stringBuffer.append(this.df.format(nhmReportDialog.getEndDate()));
            stringBuffer.append("\">");
            stringArray[1] = stringBuffer.toString();
        } else {
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append("<param NAME=time_range VALUE=");
            switch (nhmReportDialog.getTimeRange()) {
                case 2: {
                    stringBuffer.append("HOURS>");
                    break;
                }
                case 3: {
                    stringBuffer.append("DAYS>");
                    break;
                }
                case 4: {
                    stringBuffer.append("WEEKS>");
                    break;
                }
                case 5: {
                    stringBuffer.append("MONTHS>");
                    break;
                }
            }
            stringArray[0] = stringBuffer.toString();
            stringArray[1] = "<param NAME=time_length VALUE=" + nhmReportDialog.getTimeLength() + ">";
        }
        return stringArray;
    }

    private String saveChartToGifFile(JCChart jCChart, String string) {
        String string2 = this.generateUniqueImageName(string);
        try {
            Image image = jCChart.createImage(jCChart.getSize().width, jCChart.getSize().height);
            jCChart.print(image.getGraphics());
            if (image != null) {
                RemoteOutputStream remoteOutputStream = new RemoteOutputStream(string2, this.server, this.serverPort);
                GIFEncoder gIFEncoder = new GIFEncoder(image);
                gIFEncoder.Write((OutputStream)remoteOutputStream);
                remoteOutputStream.close();
            }
        }
        catch (Exception exception) {
            Traces.logException(exception);
            exception.printStackTrace();
        }
        return string2.substring(8);
    }

    private String generateUniqueImageName(String string) {
        String string2 = "reports" + File.separator + "images";
        Vector vector = null;
        try {
            RemoteDirectory remoteDirectory = new RemoteDirectory(string2, this.server, this.serverPort);
            vector = remoteDirectory.list((FilenameFilter)new GifFilenameFilter(), false);
        }
        catch (Exception exception) {
            Traces.logError(this, "Exception received trying to list reports");
            Traces.logException(exception);
        }
        int n = 1;
        String string3 = null;
        if (vector != null) {
            while (n > 0) {
                string3 = String.valueOf(string) + String.valueOf(n) + ".gif";
                Enumeration enumeration = vector.elements();
                boolean bl = false;
                while (enumeration.hasMoreElements() && !bl) {
                    FileInfo fileInfo = (FileInfo)enumeration.nextElement();
                    if (!fileInfo.getName().equals(string3)) continue;
                    bl = true;
                }
                if (!bl) {
                    n = -1;
                    continue;
                }
                ++n;
            }
        } else {
            string3 = String.valueOf(string) + String.valueOf(n) + ".gif";
        }
        return String.valueOf(string2) + File.separator + string3;
    }
}

